<?php

use Illuminate\Support\Facades\DB;

return [
    // Equipment importation
    'equipment' => [
        'table' => 'inside_sodern_equipments',
        'format'       => [
            'type'    => 'csv',
            'options' => [
                'delimiter' => ';',
                'enclosure' => ' ',
                'escape'    => '\\',
                'offset'    => 0,
            ],
        ],
        'preFlight'    => function ($console) {
            $console->info('Deleting existing equipments');
            DB::table('inside_sodern_equipments')->delete();
        },
        'fields'       => [
            'id' => 'id_materiel',
            'title'       => function ($record) {
                // {type_materiel} {nom_modele} - {numero_serie} - ID {numero_inventaire}
                // Nouvelle demande : {type_materiel} - {nom_materiel} - {fabricant} - {nom_modele}
                return ($record['type_materiel'] ?? '_') . ' - ' . ($record['nom_materiel'] ?? '_') . ' - '
                    . ($record['fabricant'] ?? '_') . ' - ' . ($record['nom_modele'] ?? '_');
            },
            'user_uuid' => function ($record) {
                if (array_key_exists('puid', $record) && !empty($record['puid'])) {
                    $user = \Inside\Content\Models\Contents\Users::where('samaccountname', $record['puid'])->first();

                    return $user ? $user->uuid : false;
                }

                return false;
            }
        ],
        'mandatory' => 'user_uuid',
    ],
    'software'  => [
        'table' => 'inside_sodern_softwares',
        'format'       => [
            'type'    => 'csv',
            'options' => [
                'delimiter' => ';',
                'enclosure' => ' ',
                'escape'    => '\\',
                'offset'    => 0,
            ],
        ],
        'preFlight'    => function ($console) {
            $console->info('Deleting existing softwares');
            DB::table('inside_sodern_softwares')->delete();
        },
        'fields'       => [
            'id' => 'installation_id',
            'title'           => function ($record) {
                return ($record['application'] ?? '_') . ' ' . ($record['editeur'] ?? '') . ' '
                    . ($record['version_application'] ?? '');
            },
            'equipment_id' => function ($record) {
                [$id_equipment, $id_software] = explode('_', $record['installation_id'], 2);

                if (DB::table('inside_sodern_equipments')->where('id', $id_equipment)->exists()) {
                    return $id_equipment;
                }

                return false;
            }
        ],
        'mandatory' => 'equipment_id',
    ],
];
