import { http } from '@inside-library/helpers/Http'

export default {
  tabSpaces: {
    add: ({ data }) => ({
      name: 'TabSpacePage',
      params: { slug: data.slug[0] }
    })
  },
  tabs: {
    add: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [{ tab_spaces: ['uuid', 'title', 'slug'] }]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: tab[0]?.tab_spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: tab } = await http.get('content/tabs', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [{ tab_spaces: ['uuid', 'title', 'slug'] }]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: tab[0]?.tab_spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      try {
        const { data: page } = await http.get('content/tabs_pages', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [
            'uuid',
            'title',
            {
              tabs: ['uuid', 'title', { tab_spaces: ['uuid', 'title', 'slug'] }]
            }
          ]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: page[0]?.tabs?.tab_spaces?.slug[0]
          },
          query: { page: data.uuid }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: page } = await http.get('content/tabs_pages', {
          filters: {
            'uuid:eq': data.uuid
          },
          fields: [
            'uuid',
            'title',
            {
              tabs: ['uuid', 'title', { tab_spaces: ['uuid', 'title', 'slug'] }]
            }
          ]
        })

        return {
          name: 'TabSpacePage',
          params: {
            slug: page[0]?.tabs.tab_spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: () => ({
      routeAs: 'add'
    })
  }
}
