import Microsoft from '@inside-auth/components/login/extra-component/Microsoft'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'ics',
        label: 'iCalendar'
      },
      {
        type: 'outlook',
        label: 'Outlook'
      },
      {
        type: 'office',
        label: 'Office'
      }
    ]
  },
  'inside-auth': {
    extraComponent: {
      is: Microsoft,
      link: `${origin}/saml/login`
    }
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-events': {
    calendarImportEnabled: true,
    showBookmarks: true,
    bookmarkEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-users': {
    csvImport: true,
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'password', restrictions: [] },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    },
    paragraphs: {
      fetchedContents: {
        display: () => import('../inside-customs/components/users/CardUser'),
        requestFields: ['uuid', 'firstname', 'lastname', 'image', 'function']
      }
    }
  },
  'inside-administration': {
    csvImport: true
  }
}
