import { http } from '@inside-library/helpers/Http'

const fetchSmallBlocks = async () => {
  try {
    const { data } = await http.get('content/small_blocks', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'link',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: 'weight:asc',
        limit: 3
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

const fetchMediumBlock = async () => {
  try {
    const { data } = await http.get('content/medium_blocks', {
      fields: [
        'uuid',
        'title',
        'image',
        'published_at',
        'link',
        'admin',
        'content_type'
      ],
      filters: {
        'status:eq': 1,
        sort: 'weight:asc',
        limit: 1
      }
    })

    return data
  } catch (err) {
    throw new Error(err)
  }
}

export { fetchSmallBlocks, fetchMediumBlock }
