import { http } from '@inside-library/helpers/Http'

export const fetchTabSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/tab_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'introduction',
        'slug',
        'admin',
        'content_type'
      ],
      filters: { 'status:eq': 1, 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
