<?php

return [
  '_meta' => [
    'type' => 'newsletters',
    'fieldsPrefix' => ''
  ],
  'logo' => [
    'showLogo' => true,
    'logoUrl' => 'vendor/maecia/isir-back/resources/assets/img/logo.png',
    'logoWidth' => 200
  ],
  'introduction' => [
    'introductionFieldName' => 'newsletter_introduction',
    'textColor' => '#2C3E50'
  ],
  'sections' => [
    'news' => [
      'sectionTitleStrKey' => 'newsletter.news_title',
      'types' => ['news'],
      'showDate' => false,
      'showCategoryTitle' => true,
      'defaultCategoryColor' => '#EA9675',
      'showIntroduction' => true,
      'link' => [
        'sectionLinkUrl' => 'actualites',
        'sectionTextColor' => '#2C3E50',
      ],
    ],
    'events' => [
      'sectionTitleStrKey' => 'newsletter.events_title',
      'types' => ['events'],
      'sorts' => ['date:desc'],
      'dateFormat' => '%d/%m/%Y',
      'categoryFieldName' => 'events_categories',
      'defaultCategoryColor' => '#1D91D3',
      'link' => [
        'sectionLinkUrl' => 'events',
        'sectionTextColor' => '#2C3E50',
      ],
    ],
    'documents' => [
      'sectionTitleStrKey' => 'newsletter.documents_title',
      'types' => ['documents'],
      'sorts' => ['created_at:desc'],
      'imageStyle' => 'medium',
      'dateFormat' => '%d/%m/%Y',
      'link' => [
        'sectionLinkStrKey' => 'newsletter.see_all_documents',
        'sectionLinkUrl' => 'bibliotheque',
        'sectionTextColor' => '#2C3E50'
      ],
    ],
    'new_members' => [
      'sectionTitleStrKey' => 'newsletter.new_members_title',
      'introductionLength' => 50,
      'introductionFieldName' => 'function',
      'types' => ['movements'],
      'fieldLabel' => [
        'movements' => [
          'fr' => 'Mouvements',
        ],
      ],
      'link' => [
        'sectionLinkUrl' => 'mouvements',
        'sectionTextColor' => '#D9232B',
        'sectionLinkStrKey' => 'newsletter.see_all_new_members',
      ],
    ],
  ],
  'footer' => [
    'backgroundColor' => '#ffffff',
    'unsubscribeTextColor' => '#818181',
    'unsubscribeTextStrKey' => 'newsletter.unsubscribe.warning'
  ],
];
