<?php

use Illuminate\Database\Migrations\Migration;

class SetFieldsAsSearchable extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        collect(['companies','services'])->each(
            fn ($contentType) => $this->bridge->updateContentTypeOptions(
                $contentType,
                [
                    'searchable' => true,
                    'search_result_field' => true
                ]
            )
        );


        collect(['mobile_phone', 'phone'])
            ->each(fn ($field) =>  $this->bridge->updateFieldOptions(
                'users',
                $field,
                [
                    'searchable' => true,
                    'search_result_field' => true
                ]
            ));

        $this->call('models:rebuild');
        $this->call('index:rebuild', ['--type' => 'users']);
        $this->finishUp();
    }
}
