<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

final class AddUsersHideInDirectoryField extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeCreateOrUpdateField(
            type: 'users',
            fieldName: 'hide_in_directory',
            options: [
                'name' => 'in_directory',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => true,
                'searchable_filter' => true,
                'required' => false,
                'weight' => 1,
                'title' => [
                    'fr' => "Afficher dans l'annuaire",
                ],
                'description' => [
                    'fr' => "Afficher ou non l'utilisateur dans l'annuaire",
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 1,
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => false,
            ]
        );

        Artisan::call('models:rebuild');

        $bridgeContent = new BridgeContent();

        Users::query()
            ->whereNull('hide_in_directory')
            ->pluck('uuid')
            ->each(function (string $userUuid) use ($bridgeContent) {
                try {
                    $bridgeContent->contentUpdate('users', ['uuid' => $userUuid, 'hide_in_directory' => false]);
                } catch (Exception) {
                    $this->getConsole()->writeln("<error>Error for user $userUuid</error>");
                }
            });

        $this->finishUp();
    }
}
