<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Models\Contents\Services;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;

final class EditServiceAndCompaniesLabelsAndDeleteServiceContent extends Migration
{
    public function up(): void
    {
        $contentTypeBridge = new BridgeContentType();

        collect([
            [ 'name' => "services", 'title' => 'Service/Pôle' ],
            [ 'name' => "companies", 'title' => 'Direction' ],
            ])->each(function ($contentType) use ($contentTypeBridge) {
                $contentTypeBridge->contentTypeUpdate($contentType['name'], ['title' => [ 'fr' => $contentType['title'], ]]);
                $contentTypeBridge->changeFieldTitle('users', $contentType['name'], [ 'fr' => $contentType['title'] ]);
            });

        Artisan::call('models:rebuild');

        $contentBridge = new BridgeContent();
        Services::each(fn ($service) => $contentBridge->contentDelete('services', $service->uuid));
    }
}
