<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class CreateCompaniesContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        // Creating the functions content type
        $this->migrateContent('companies');
        $this->finishUp();

        $contentTypeBridge = new BridgeContentType();

        $contentTypeBridge->contentTypeCreateField(
            'users',
            'companies',
            [
                'name' => 'companies',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Société',
                    ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [
                        'size' => 60,
                        'placeholder' => '',
                    ],
                    'weight' => 11,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['companies'],
                    'cardinality' => 1,
                ],
                'selectable_all' => false,
            ],
            null,
            'user',
        );

        Artisan::call('models:rebuild');
    }
}
