<?php

use Illuminate\Database\Migrations\Migration;

class UpdateUserContentType extends Migration
{
    use \Inside\Host\Migrations\CreateContentTypes;

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->bridge->updateContentTypeOptions(
            'users',
            ['searchable' => true]
        );
        collect(['firstname', 'lastname'])
            ->each(fn ($field) =>  $this->bridge->updateFieldOptions('users', $field, ['required' => false]));
        $this->call('models:rebuild');
        $this->finishUp();
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
    }
}
