<?php

declare(strict_types=1);

use Inside\Content\Models\Contents\Users;

return [
    'files' => [
        'isir' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/import.xlsx'),
            'fields' => [
                'name' => 'e-mail',
                'mail' => 'e-mail',
                'lastname' => "nom d'usage ou marital",
                'firstname' => 'prénom',
                'status' => fn () => true,
                'hide_in_directory' => fn () => true,
                'send_mail' => fn ($record): bool => Users::where('email', $record['e-mail'])->doesntExist(),
            ],
            'original_fields' => [
                'e-mail' => 'mail',
                'prénom' => 'firstname',
                'nom d\'usage ou marital'  => 'lastname'
            ],
        ],
    ],
];
