<?php

use Illuminate\Support\Collection;
use Inside\Content\Models\Contents\Users;
use Inside\Host\Bridge\BridgeContent;

function get_entity_reference(mixed $user, BridgeContent $bridge, string $attribute, string $contentType): ?string
{
    $title = $user->{$attribute};

    if (! $title) {
        return null;
    }

    $entity = call_user_func(type_to_class($contentType).'::query')
        ->where('title', $title)->first();

    if ($entity) {
        $uuid = $entity->uuid;
    } else {
        $uuid = $bridge->contentInsert($contentType, [
            'type' => 'node',
            'bundle' => $contentType,
            'title' => $title,
        ]);
    }

    return $uuid;
}

return [
    'postfilter' => static function (Collection $users): Collection {
        return $users->map(function (stdClass $user) {
            if (!empty($user->businessPhones)) {
                $user->businessPhones = $user->businessPhones[0];
            }
            return $user;
        });
    },
    'sync_attributes' => [
        'mail' => 'userPrincipalName',
        'name' => 'displayName',
        'lastname' => 'surname',
        'firstname' => 'givenName',
        'function' => 'jobTitle',
        'phone' => 'businessPhones',
        'mobile_phone' => 'mobilePhone',
        'services' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($user, $bridge, 'faxNumber', 'services'),
        'companies' => fn (mixed $user, BridgeContent $bridge) => get_entity_reference($user, $bridge, 'companyName', 'companies'),
        'manager' => static function ($user, BridgeContent $bridge): ?string {
            if (! isset($user->manager)) {
                return null;
            }

            return Users::select('uuid', 'email')->where('email', $user->manager)->where('status', 1)->first()?->uuid;
        },
        'status' => fn () => true,
        'hide_in_directory' => fn (mixed $user) => Users::select('hide_in_directory')
            ->where('email', $user->userPrincipalName)
            ->first()?->hide_in_directory ?? false,
    ],
    'custom_attributes' => [
        'manager' => 'mail',
    ],
];
