import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'
import CrossroadPage from '../pages/crossroad/CrossroadPage'

import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/fetch'

import { fetchCrossroadPage } from '../components/crossroad/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox', authorFields: [] }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1,
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    props: {
      cardOverlayEnabled: false,
      extraFilters: {
        sort: 'weight:asc'
      }
    }
  },
  {
    name: 'TabsSpacePage',
    meta: { disabled: false }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false }
  },
  {
    name: 'UpdatedContentsPage',
    path: '/contenus-mis-a-jour',
    component: () => import('../pages/updated-contents/UpdatedContentsPage')
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'ConstitutionPage',
    path: '/constitution',
    component: () => import('../pages/constitution/ConstitutionPage')
  },
  {
    name: 'ConstitutionArticlePage',
    path: '/constitution/articles',
    component: () => import('../pages/constitution/ConstitutionArticlePage')
  },
  {
    name: 'GovernmentsPage',
    path: '/gouvernements',
    component: () => import('../pages/governments/GovernmentsPage')
  },
  {
    name: 'GovernmentsInformationPage',
    path: '/gouvernements-sgg',
    component: () => import('../pages/governments/GovernmentsInformationPage')
  },
  {
    name: 'CrossroadPage',
    path: '/page-carrefour/:slug',
    component: withFetch(CrossroadPage, { size: 'xxl' })(fetchCrossroadPage)
  }
]
