import { http } from '@inside-library/helpers/Http'

export const fetchCrossroadPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/crossroad_pages', {
      fields: [
        'uuid',
        'title',
        'admin',
        'content_type',
        'content',
        'banner',
        'introduction',
        {
          crossroad_page_blocks: {
            fields: ['uuid', 'title', 'image', 'lien', 'content_type', 'admin'],
            filters: { reverse: true, 'status:eq': 1, sort: 'published_at:desc' }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
