export default {
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'image',
      'firstname',
      'lastname',
      'function',
      'email',
      'phone',
      'mobile_phone',
      { direction: ['uuid', 'title'] },
      {
        manager: {
          fields: ['uuid', 'firstname', 'lastname', 'function', 'image', 'phone'],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0
          }
        }
      },
      {
        'users.manager': {
          fields: ['firstname', 'lastname', 'uuid', 'function', 'image', 'phone'],
          filters: {
            'status:eq': 1,
            'is_maintenance:eq': 0,
            alias: 'coworkers'
          }
        }
      }
    ]
  }
}
