import { http } from '@inside-library/helpers/Http'

export default {
  constitutionTitles: {
    add: () => ({
      name: 'ConstitutionPage'
    }),
    delete: () => ({
      name: 'ConstitutionPage'
    }),
    globalSearch: () => ({ routeAs: 'add' })
  },
  constitutionArticles: {
    add: ({ data }) => ({
      name: 'ConstitutionArticlePage',
      query: { page: data.uuid }
    }),
    delete: () => ({
      name: 'ConstitutionPage'
    }),
    globalSearch: () => ({ routeAs: 'add' })
  },
  governments: {
    add: ({ data }) => ({
      name: 'GovernmentsInformationPage',
      query: { page: data.uuid }
    }),
    delete: () => ({
      name: 'GovernmentsPage'
    }),
    globalSearch: () => ({ routeAs: 'add' })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            'slug',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'SpacesPage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: [
            'uuid',
            {
              spaces: {
                fields: ['uuid', 'title', 'slug']
              }
            }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'SpacesPage',
        params: {
          slug: pagesCategories[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: pagesCategories } = await http.get(
        'content/pages_categories',
        {
          fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'SpacesPage',
          params: {
            slug: pagesCategories[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: { slug: spacesPages[0].pages_categories.spaces.slug[0] },
          query: { page: data.uuid }
        }
      }
    }
  },
  crossroadPageBlocks: {
    add: async ({ data }) => {
      const { data: blocks } = await http.get(
        'content/crossroad_page_blocks',
        {
          fields: [
            'uuid',
            'title',
            { crossroad_pages: ['uuid', 'title', 'slug'] }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'CrossroadPage',
        params: {
          slug: blocks?.[0]?.crossroad_pages?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: blocks } = await http.get(
        'content/crossroad_page_blocks',
        {
          fields: [
            'uuid',
            'title',
            { crossroad_pages: ['uuid', 'title', 'slug'] }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'CrossroadPage',
        params: {
          slug: blocks?.[0]?.crossroad_pages?.slug[0]
        }
      }
    }
  },
  crossroadPages: {
    add: async ({ data }) => {
      const { data: page } = await http.get(
        'content/crossroad_pages',
        {
          fields: ['uuid', 'slug'],
          filters: {
            'status:eq': 1,
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'CrossroadPage',
        params: {
          slug: page?.[0]?.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: page } = await http.get(
        'content/crossroad_pages',
        {
          fields: ['uuid', 'slug'],
          filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
        }
      )

      return {
        route: {
          name: 'CrossroadPage',
          params: {
            slug: page?.[0]?.slug[0]
          }
        }
      }
    }
  }
}
