<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

final class UpdateGlobalSearchTypes extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $contentTypes = ['constitution_titles', 'pages_categories', 'spaces', 'custom', 'news', 'faq_questions'];

        collect($contentTypes)
            ->each(function ($contentType) use ($bridgeContentType) {
                $bridgeContentType->updateContentTypeOptions($contentType, ['global_searchable' => false]);
            });
    }
}
