<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Inside\Content\Facades\Schema as InsideSchema;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;

class ConvertTimestampToDatetimeForPublishedAt extends Migration
{
    public function up(): void
    {
        $tableNames = collect([
            'inside_search_database_indexes'
        ]);

        $contentTypes = InsideSchema::getContentTypes();

        $contentTypeTables = collect($contentTypes)->map(function ($contentType) {
            return type_to_table($contentType);
        });

        $tableNames = $tableNames->merge($contentTypeTables)->unique();

        $tableNames->each(function ($tableName) {
            if (!Schema::hasTable($tableName)) {
                return;
            }

            if (!Schema::hasColumn($tableName, 'published_at') || !Schema::hasColumn($tableName, 'created_at')) {
                return;
            }

            $this->convertTimestampToDatetime($tableName);
            $this->fixPublishedAt($tableName);
        });

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild');
    }

    private function convertTimestampToDatetime(string $tableName): void
    {
        Schema::table($tableName, function (Blueprint $table) {
            $table->dateTime('published_at')->nullable()->change();
        });
    }

    private function fixPublishedAt(string $tableName): void
    {
        DB::table($tableName)
            ->where('published_at', "0000-00-00 00:00:00")
            ->update(['published_at' => DB::raw('created_at')]);
    }
}
