<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class UpdateConstitutionArticleContent extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'constitution_articles',
            fieldName: 'article_content',
            options: [
                'name' => 'article_content',
                'searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => 4,
                'title' => [
                    'fr' => 'Contenu de l\'article',
                ],
                'description' => [
                    'fr' => 'Encadré comportant l\'article de loi',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => 4,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            weight: 4
        );

        Artisan::call('models:rebuild');
        Artisan::call('index:rebuild --type=constitution_articles');
    }
}
