<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class UpdateConstitutionArticleWysiwig extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'constitution_articles',
            fieldName: 'article_introduction',
            options: [
                'name' => 'article_introduction',
                'searchable' => true,
                'global_searchable' => true,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => -1,
                'title' => [
                    'fr' => 'Introduction de l\'article',
                ],
                'widget' => [
                    'type' => BridgeContentType::WYSIWYG_WIDGET,
                    'settings' => [],
                    'weight' => -1,
                ],
                'type' => BridgeContentType::WYSIWYG_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            weight: -1
        );

        Artisan::call('models:rebuild');
    }
}
