<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema as InsideSchema;

class UpdateGlobalSearchContent extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $newContentTypes = collect([
            'governments',
            'constitution_articles',
            'constitution_titles',
            'documents',
            'tools',
            'direction',
            'manager',
            'tabs',
            'tabs_pages',
            'tabs_spaces',
            'faq_questions',
            'news',
            'pages',
            'custom',
            'users',
        ]);

        $oldContentTypes = collect([
            'faq_categories',
            'folders',
        ]);

        $newContentTypes->each(function ($contentType) use ($bridge) {
            if (InsideSchema::hasContentType($contentType)) {
                $bridge->updateContentTypeOptions(
                    type: $contentType,
                    options: [
                        'global_searchable' => true,
                        'searchable' => true,
                    ]
                );
            }
        });

        $oldContentTypes->each(function ($contentType) use ($bridge) {
            if (InsideSchema::hasContentType($contentType)) {
                $bridge->updateContentTypeOptions(
                    type: $contentType,
                    options: [
                        'global_searchable' => false,
                    ]
                );
            }
        });
    }
}
