<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateUsersReference extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField(
            entityType: "user",
            type: "user",
            fieldName: 'manager'
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: "users",
            fieldName: 'manager',
            options:         [
                    'name' => 'manager',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 3,
                    'title' => [
                        'fr' => 'Manager',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::AUTOCOMPLETE_WIDGET,
                        'settings' => [],
                        'weight' => 3,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => 'users',
                        'cardinality' => 1,
                    ],
                ],
            weight: 3
        );

        Artisan::call("models:rebuild");
    }
}
