<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateToolsWeight extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools',
            fieldName: 'tools_link',
            options: [
                    'name' => 'tools_link',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => true,
                    'weight' => 5,
                    'title' => [
                        'fr' => 'Lien',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::INSIDE_LINK_WIDGET,
                        'settings' => [],
                        'weight' => 5,
                    ],
                    'type' => BridgeContentType::TEXT_FIELD,
                    'settings' => [
                        'max_length' => 255,
                        'is_ascii' => false,
                        'case_sensitive' => false,
                        'cardinality' => 1,
                    ],
                ],
            weight: -2
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: 'tools',
            fieldName: 'weight',
            options: [
                    'name' => 'weight',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 6,
                    'title' => [
                        'fr' => 'Ordre d\'affichage',
                    ],
                    'description' => [
                        'fr' => 'Le chiffre le plus bas remonte en 1er',
                    ],
                    'widget' => [
                        'type' => BridgeContentType::NUMBER_WIDGET,
                        'settings' => [],
                        'weight' => 6,
                    ],
                    'type' => BridgeContentType::INTEGER_FIELD,
                    'settings' => [
                        'cardinality' => 1,
                    ],
                    'default' => 0,
                ],
            weight: -2
        );
    }
}
