<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'constitution_articles',
        'translatable' => true,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => true,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Article Constitution',
        ],
    ],
    'fields' => [
        [
            'name' => 'constitution_titles',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Titre Constitution',
            ],
            'description' => [
                'fr' => 'Choix de la Constitution dans laquelle l\'article doit remonter',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['constitution_titles'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
        [
            'name' => 'article_number',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 2,
            'title' => [
                'fr' => 'Numéro de l\'article',
            ],
            'description' => [
                'fr' => 'Titre remonté dans l\'arborescence de la Constitution',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [
                    'size' => 60,
                    'placeholder' => '',
                ],
                'weight' => 2,
            ],
            'type' => BridgeContentType::TEXT_FIELD,
            'settings' => [
                'max_length' => 255,
                'is_ascii' => false,
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'article_introduction',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 3,
            'title' => [
                'fr' => 'Introduction de l\'article',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => 3,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'article_content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 4,
            'title' => [
                'fr' => 'Contenu de l\'article',
            ],
            'description' => [
                'fr' => 'Encadré comportant l\'article de loi',
            ],
            'widget' => [
                'type' => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
                'weight' => 4,
            ],
            'type' => BridgeContentType::WYSIWYG_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 5,
            'title' => [
                'fr' => 'Contenu',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 5,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
    ],
];
