<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

final class UpdateTargetSectionFields extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $unwantedTargets = ['html', 'map'];

        collect(Schema::getAllFieldsListingOfType('section'))
            ->each(function ($fieldNames, $contentType) use ($bridgeContentType, $unwantedTargets) {
                collect($fieldNames)->each(function ($fieldName) use ($contentType, $bridgeContentType, $unwantedTargets) {
                    $fieldOptions = Schema::getFieldOptions($contentType, $fieldName);

                    $targets = collect($fieldOptions['target']);
                    $hadUnwantedTargets = $targets->contains(fn ($item) => in_array($item, $unwantedTargets));

                    if ($hadUnwantedTargets) {
                        $filteredTargets = $targets
                            ->reject(fn ($item) => in_array($item, $unwantedTargets))
                            ->values()
                            ->toArray();

                        $bridgeContentType->updateFieldOptions(
                            type: $contentType,
                            fieldName: $fieldName,
                            options: ['target_type' => $filteredTargets]
                        );
                    }
                });
            });
    }
}
