<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class AddSearchableConstitutionIntroduction extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateFieldOptions(
            type: 'constitution_articles',
            fieldName: 'article_introduction',
            options: [
                'global_searchable' => true,
            ]
        );

        Artisan::call('index:rebuild --type=constitution_articles');
    }
}
