<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\Schema;
use Inside\Host\Bridge\BridgeContentType;

class AddAdvancedTableSectionToTypes extends Migration
{
    public function up(): void
    {
        $contentTypes = [
            'tabs_pages',
            'pages',
            'constitution_articles',
            'governments',
            'spaces_pages'
        ];

        $bridge = new BridgeContentType();
        collect($contentTypes)->each(function (string $type) use ($bridge) {
            $sectionOptions = Schema::getFieldOptions($type, 'content');
            $sectionOptions['target'][] = 'advanced_table';

            $bridge->updateFieldOptions(
                type: $type,
                fieldName: 'content',
                options: [
                    'target_type' => $sectionOptions['target']
                ]
            );
        });
    }
}
