<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContent;
use Inside\Content\Models\Contents\LinkBlocksMenus;
use Inside\Content\Facades\Schema;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class RenameLinkBlocksMenus extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (! Schema::hasModel('link_blocks_menus')) {
            return;
        }

        $this->bootUp(__FILE__);
        $this->migrateContent('link_blocks', false);
        $this->finishUp();

        Artisan::call('models:rebuild');

        $bridge = new BridgeContent();
        $bridgeContentType = new BridgeContentType();

        LinkBlocksMenus::all()->each(function ($content) use ($bridge) {
            $contentToCreate = array_except($content->toArray(), ['uuid', 'uuid_host', 'created_at', 'updated_at', 'published_at','author','author_id','update_author','pid']);

            $bridge->contentInsert(
                type: 'link_blocks',
                data: $contentToCreate,
                creation: true,
                fromCli: true
            );
        });

        $bridgeContentType->contentTypeDelete('link_blocks_menus');
    }
}
