<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class MakeAliasableContentsForIsgg extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'governments',
            'tabs_pages',
        ]);

        $contentTypes->each(function ($contentType) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $contentType,
                options: [
                    'aliasable' => true,
                ]
            );
        });
    }
}
