<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateUsersFields extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'Direction / Département' => 'direction',
            'Manager' => 'manager',
        ]);

        $count = 0;

        $contentTypes->each(function ($machineName, $label) use ($bridge, &$count) {
            $bridge->contentTypeUpdateOrCreate(
                type: $machineName,
                options: [
                'name' => $machineName,
                'translatable' => true,
                'searchable' => true,
                'global_searchable' => false,
                'aliasable' => false,
                'permissible' => false,
                'categorizable' => true,
                'listing_type' => 'content',
                'title' => [
                    'fr' => $label,
                ],
            ],
            );

            $bridge->contentTypeCreateOrUpdateField(
                type: "users",
                fieldName: $machineName,
                options:         [
                    'name' => $machineName,
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => true,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 3,
                    'title' => [
                        'fr' => $label,
                    ],
                    'widget' => [
                        'type' => $count === 0 ? BridgeContentType::SELECT_WIDGET : BridgeContentType::AUTOCOMPLETE_WIDGET,
                        'settings' => [],
                        'weight' => 3,
                    ],
                    'type' => BridgeContentType::REFERENCE_FIELD,
                    'settings' => [
                        'target_type' => [$machineName],
                        'cardinality' => 1,
                    ],
                ],
                weight: 3
            );
            $count++;
        });

        Artisan::call("models:rebuild");
    }
}
