<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateCrossroad extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->updateContentTypeOptions(
            type: "crossroad_pages",
            options: [
                'aliasable' => true,
            ]
        );

        $bridge->contentTypeCreateOrUpdateField(
            type: "crossroad_page_blocks",
            fieldName: "crossroad_pages",
            options: [
                'name' => 'crossroad_pages',
                'searchable' => false,
                'translatable' => true,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => true,
                'weight' => -2,
                'title' => [
                    'fr' => 'Page carrefour associée',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => -2,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['crossroad_pages'],
                    'cardinality' => 1,
                ],
            ],
            weight: -2
        );
    }
}
