<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Bridge\BridgeContentType;

class UpdateAliasable extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentTypes = collect([
            'tabs_spaces',
            'tools_categories_listings',
            'constitution_articles',
        ]);

        $contentTypes->each(function ($contentType) use ($bridge) {
            $bridge->updateContentTypeOptions(
                type: $contentType,
                options: [
                    'aliasable' => true,
                ]
            );
        });
    }
}
