<?php

use Inside\Host\Bridge\BridgeContentType;

return [
    'options' => [
        'name' => 'tabs_pages',
        'translatable' => true,
        'searchable' => false,
        'global_searchable' => false,
        'aliasable' => false,
        'permissible' => false,
        'categorizable' => false,
        'listing_type' => 'content',
        'title' => [
            'fr' => 'Sous Page Onglet',
        ],
    ],
    'fields' => [
        [
            'name' => 'tabs',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => true,
            'weight' => 0,
            'title' => [
                'fr' => 'Onglets',
            ],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['tabs'],
                'cardinality' => 1,
            ],
        ],
        [
            'name' => 'content',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 1,
            'title' => [
                'fr' => 'Contenu',
            ],
            'description' => [
                'fr' => 'Sélectionnez les différents types de paragraphes que vous voulez faire remonter sur la page',
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraphe',
                    'title_plural' => 'Paragraphes',
                    'edit_mode' => 'open',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '',
                ],
                'weight' => 1,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'text',
                    'text_two_columns',
                    'text_with_image',
                    'separator',
                    'file',
                    'slider',
                    'image',
                    'video',
                    'map',
                    'accordion',
                    'call_to_action',
                    'button',
                    'html',
                    'fetched_contents',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name' => 'weight',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 2,
            'title' => [
                'fr' => 'Ordre d\'affichage',
            ],
            'description' => [
                'fr' => 'Le chiffre le plus bas remonte en 1er',
            ],
            'widget' => [
                'type' => BridgeContentType::NUMBER_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
            'type' => BridgeContentType::INTEGER_FIELD,
            'settings' => [
                'cardinality' => 1,
            ],
            'default' => 0,
        ],
    ],
];
