<?php

return [
    'files' => [
        'isgg' => [
            'path' => env('XLSX_USERS_PATH', __DIR__.'/../../../../imports/import.xlsx'),
            'fields' => [
                'email' => 'email',
                'name' => 'email',
                'firstname' => 'prénom',
                'lastname' => 'nom',
                'mobile_phone' => 'téléphone mobile',
                'phone' => 'téléphone fixe',
                'function' => 'fonction',
                'manager' => fn (mixed $record) => reference('users')
                    ->identifiedBy('email')
                    ->from($record['mail manager'])
                    ->withoutCreation()
                    ->first(),
                'direction' => fn (mixed $record) => reference('direction')
                    ->identifiedBy('code')
                    ->from($record['direction/département'])
                    ->get(),
                'status' => fn () => true,
            ],
            'original_fields' => [
                'email' => 'mail',
                'prénom' => 'firstname',
                'nom'  => 'lastname',
                'téléphone mobile' => 'mobile',
                'téléphone fixe' => 'phone',
                'fonction' => 'function',
                'mail manager' => 'mail',
                'direction/département' => 'word'
            ],
        ],
    ],
];
