import Google from '@inside-auth/components/login/extra-component/Google'

const origin = new URL(
  process.env.NODE_ENV === 'development'
    ? JSON.parse(process.env.GLOBAL).localURL
    : window.location
).origin

export default {
  globals: {
    calendarExportTypes: [
      {
        type: 'google',
        label: 'Google'
      }
    ]
  },
  'inside-administration': {
    disabledAdvancedSettingsFields: ['ged_enable_likes']
  },
  'inside-auth': {
    extraComponent: {
      is: Google,
      link: `${origin}/google/login`
    }
  },
  'inside-commons': {
    banner: {
      darkMode: true
    }
  },
  'inside-edition': {
    duplicateEnabled: true
  },
  'inside-events': {
    bookmarkEnabled: true,
    showBookmarks: true,
    subscriptionEnabled: true
  },
  'inside-ged': {
    useBookmarks: true
  },
  'inside-layouts': {
    gdprContent: 'popins',
    addContentTypes: {
      homepage: [
        'news',
        'news_categories',
        'events',
        'events_categories',
        'movements'
      ]
    },
  },
  'inside-news': {
    bookmarkEnabled: true,
    authorEnabled: true,
    minimalDate: true
  },
  'inside-users': {
    shortcuts: {
      max: 5
    },
    allowAvatarEdition: false,
    allowAvatarDeletion: false,
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'bookmarks', restrictions: [], icon: 'bookmark' },
        { name: 'shortcuts', restrictions: [], icon: 'news' }
      ]
    }
  }
}
