export default {
  users: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'firstname',
      'lastname',
      'function',
      'email',
      'image',
      'phone',
      'linkedin',
      'birthday',
      { services: ['uuid', 'title'] },
      {
        managers: [
          'uuid',
          'firstname',
          'lastname',
          'phone',
          'function',
          'image'
        ]
      }
    ]
  },
  documents: {
    extendedUrl: ['uuid'],
    modalFields: [
      'uuid',
      'title',
      'content_type',
      'admin',
      'content',
      'published_at',
      'updated_at',
      'file',
      'image',
      { folders: ['title', 'uuid'] },
      { authors: ['uuid', 'firstname', 'lastname'] }
    ]
  },
  vacations: {
    extendedUrl: ['uuid'],
    editionDisabled: true,
    modalFields: [
      'title',
      'uuid',
      'date',
      'end_date',
      'comment',
      'start_timeframes',
      'end_timeframes',
      { authors: ['uuid', 'image', 'firstname', 'lastname'] },
      { validator: ['uuid', 'image', 'firstname', 'lastname'] },
      { vacations_status: ['uuid', 'color', 'title', 'value'] }
    ]
  }
}
