import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'

import {
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces/fetch'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    meta: { disabled: false, isCustomPage: true }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'ToolsPage',
    meta: { disabled: false },
    props: {
      extraFilters: {
        sort: ['weight:asc', 'title:asc'],
        'published_at:lte': 'now()'
      },
      toolsFilters: {
        'status:eq': 1,
        sort: 'weight:asc',
        'published_at:lte': 'now()'
      }
    }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/directory/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'AgendaListingPage',
    meta: { disabled: false }
  },
  {
    name: 'AgendaPage',
    meta: { disabled: false }
  },
  {
    name: 'MapPage',
    meta: { disabled: false }
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'TabsSpacePage',
    props: {
      bannerData: {
        add: ['tabs', 'tabs_pages']
      }
    },
    meta: { disabled: false }
  },
  {
    name: 'SimplePage',
    meta: { disabled: false, content: 'pages' }
  },
  {
    name: 'FAQListingPage',
    meta: { disabled: false }
  },
  {
    name: 'AdminAdvancedSettingsWeatherPage',
    meta: { admin: true, display: true }
  }
]
