import { http } from '@inside-library/helpers/Http'

export default {
  roomsCategories: {
    add: () => ({
      name: 'AgendaListingPage'
    }),
    delete: () => ({
      name: 'AgendaListingPage'
    })
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    add: async ({ data }) => {
      const { data: cat } = await http.get('content/pages_categories', {
        fields: [
          'uuid',
          'slug',
          {
            spaces: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: cat[0].spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: cat } = await http.get('content/pages_categories', {
        fields: [
          'uuid',
          {
            spaces: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: cat[0].spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: cat } = await http.get('content/pages_categories', {
        fields: ['uuid', { spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: cat[0].spaces.slug[0]
          }
        }
      }
    }
  },
  spacesPages: {
    add: async ({ data }) => {
      const { data: spacePages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'slug',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacePages[0].pages_categories.spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'SpacesPagesPage',
        params: {
          slug: spacesPages[0].pages_categories.spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: spacesPages } = await http.get('content/spaces_pages', {
        fields: [
          'uuid',
          'title',
          {
            pages_categories: [
              'uuid',
              'title',
              {
                spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'SpacesPagesPage',
          params: {
            slug: spacesPages[0].pages_categories.spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
