<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Content\Facades\Schema;

class TranslateContentTypes extends Migration
{
    public function up(): void
    {
        $types = [
            "blocks",
            "connexion_popups",
            "courses",
            "courses_categories",
            "courses_chapters",
            "courses_lessons",
            "courses_quizzes",
            "custom",
            "events",
            "events_categories",
            "faq_categories",
            "faq_questions",
            "flash_news",
            "forms",
            "listing_courses_categories",
            "marker",
            "movements",
            "movements_categories",
            "news",
            "news_categories",
            "organization_items",
            "organizations",
            "organizations_categories",
            "pages",
            "pages_categories",
            "popins",
            "public_pages",
            "rooms",
            "rooms_categories",
            "rooms_reservations",
            "services",
            "spaces",
            "spaces_pages",
            "tabs",
            "tabs_pages",
            "tabs_spaces",
            "tools",
            "tools_categories",
            "tools_categories_listings",
            "top_footer",
            "tv_cards",
            "tv_datetime",
            "tv_events",
            "tv_movements",
            "tv_news",
            "tv_screens",
            "tv_videos",
            "tv_weathers",
            "vacations",
            "vacations_status",
            "vacations_timeframes",
        ];

        $bridgeContentType = new BridgeContentType();
        foreach ($types as $type) {
            $bridgeContentType->contentTypeUpdateOrCreate($type, [
                'name' => $type,
                'translatable' => true
            ]);
        }
    }
}
