<?php

namespace Inside\ISDR\Providers;

use Inside\Kernel\Authentication\SingleSignOnProviderEnum;
use Inside\Kernel\Authentication\Facades\SingleSingOnRedirection;
use Inside\Providers\ServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * ISDR Service provider.
 *
 * @category Class
 * @package  Inside\\ISDR\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    /**
     * Boot
     */
    public function boot(): void
    {
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');
    }

    /**
     * Register
     */
    public function register(): void
    {
        SingleSingOnRedirection::setProvider(SingleSignOnProviderEnum::GOOGLE)->enable();

        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
            $this->mergeConfigTo(__DIR__.'/../../config/google.php', 'google');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
