<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Artisan;
use Inside\Content\Facades\ContentBlueprints;
use Inside\Host\Migrations\CreateContentTypes;

class ActivateLoginPoppin extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent(contentType: 'popins');
        $this->finishUp();

        Artisan::call("models:rebuild");
    }

    public function down(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeDelete('popins');
        $this->finishUp();
    }
}
