<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentBlueprints;
use Illuminate\Support\Facades\Artisan;
use Inside\Host\Migrations\CreateContentTypes;

final class InstallFaqFromBlueprint extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        ContentBlueprints::generateContent('faq_categories');
        ContentBlueprints::generateContent('faq_questions');
        $this->finishUp();

        Artisan::call("models:rebuild");
    }
}
