<?php

use Google\Service\PeopleService;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Inside\Content\Models\Contents\Services;
use Inside\Content\Models\Contents\Users;
use Inside\Facades\Http;
use Inside\User\Models\User;

return [
    'scopes' => [
        'https://www.googleapis.com/auth/admin.directory.user.readonly',
        'https://www.googleapis.com/auth/admin.directory.group.readonly',
        'https://www.googleapis.com/auth/admin.directory.group.member.readonly'
    ],
    'sync_attributes' => [
        'mail' => 'getPrimaryEmail',
        'name' => 'getPrimaryEmail',
        'firstname' => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['givenName'];
        },
        'lastname' => function (\Google_Service_Directory_User $user, $bridge) {
            $name = $user->getName();

            return $name['familyName'];
        },
        'birthday' => function (\Google_Service_Directory_User $user, $bridge) {
            $custom = $user->getCustomSchemas();
            if ($custom['Date_de_naissance']) {
                return date('Y-m-d H:i:s', strtotime($custom['Date_de_naissance']['Date_de_naissance']));
            }
        },
        'phone' => function (\Google_Service_Directory_User $user, $bridge) {
            $phones = $user->getPhones();
            foreach ($phones as $phone) {
                if ($phone['type'] === "work") {
                    return $phone['value'];
                }
            }
        },
        'function' => function (\Google_Service_Directory_User $user, $bridge) {
            $organizations = $user->getOrganizations();
            $maecia = $organizations[0];
            if ($maecia) {
                return $maecia['title'];
            }
        },
        'managers' => function (\Google_Service_Directory_User $user, $bridge) {
            $relations = $user->getRelations();
            if (!$relations) {
                return [];
            }
            $managers = array_filter(
                $relations,
                function ($element) {
                    if ($element['type'] === "manager") {
                        return $element;
                    }
                }
            );
            $users = [];
            foreach ($managers as $manager) {
                $user = Users::query()->where('email', $manager['value'])->first();
                if ($user) {
                    array_push($users, $user->uuid);
                }

                return $users;
            }
        },
        'image' => fn (\Google_Service_Directory_User $user, $bridge, $service) => avatar($user->getThumbnailPhotoUrl(), User::query()->where('email', $user->getPrimaryEmail())->first()),
        'services' => function (\Google_Service_Directory_User $user, $bridge) {
            $organizations = $user->getOrganizations();
            $maecia = $organizations[0];
            if ($maecia) {
                $service = Services::query()->where('title', $maecia['department'])->first();
                if ($service) {
                    return $service->uuid;
                }
            }
        },
    ],
];
