import { ROUTE_NAMES as NEWS_ROUTE } from '@inside-news/constants'
import TOOLS_ROUTE from '@inside-tools/routes'
import { ROUTE_NAMES as EVENTS_ROUTE } from '@inside-events/constants'

import SpacesListingPage from '../pages/spaces/SpacesListingPage'
import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'

import {
  fetchSpacesListingPage,
  fetchSpacesPage,
  fetchSpacesPagesPage
} from '../components/spaces'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/home/HomePage'),
    meta: { disabled: false }
  },
  {
    name: NEWS_ROUTE.listing,
    meta: {
      disabled: false
    }
  },
  {
    name: NEWS_ROUTE.page,
    meta: {
      disabled: false
    }
  },
  {
    name: TOOLS_ROUTE[0].name,
    meta: {
      disabled: false
    },
    props: {
      requestFilters: {
        sort: 'weight:asc',
        'status:eq': 1
      },
      toolsFilters: {
        sort: 'weight:asc',
        'status:eq': 1
      }
    }
  },
  {
    name: EVENTS_ROUTE.page,
    meta: {
      disabled: false
    }
  },
  {
    name: EVENTS_ROUTE.calendar,
    meta: {
      disabled: false
    }
  },
  {
    name: EVENTS_ROUTE.subscription,
    meta: {
      disabled: false
    }
  },
  {
    name: 'AdminUsersPage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false
    }
  },
  {
    name: 'GedPage',
    meta: {
      disabled: false
    },
    props: {
      gridMinMax: '200',
      cardSize: 's'
    }
  },
  {
    name: 'SpacesListingPage',
    path: '/espaces',
    component: withFetch(SpacesListingPage, { size: 'xxl' })(
      fetchSpacesListingPage
    )
  },
  {
    name: 'SpacesPage',
    path: '/espaces/:slug',
    component: withFetch(SpacesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'SpacesPagesPage',
    path: '/espaces/:slug/pages',
    component: withFetch(SpacesPagesPage, { size: 'xxl' })(fetchSpacesPagesPage)
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/DirectoryPage')
  },
  {
    name: 'StoriesListingPage',
    path: '/success-stories',
    component: () => import('../pages/stories/StoriesListingPage')
  }
]
