export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.slug[0] }
    })
  },
  pagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: { slug: data.spaces.slug[0] }
    })
  },
  spacesPages: {
    fields: ['uuid', { pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      },
      query: { page: data.uuid }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.pages_categories.spaces.slug[0]
      }
    })
  },
  stories: {
    add: () => ({
      name: 'StoriesListingPage'
    }),
    delete: () => ({
      name: 'StoriesListingPage'
    }),
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'success-stories',
          'fetch',
          { item: { uuid: data.uuid }, content: 'stories' },
          { layout: 'right', size: 'm', transition: 'fadeIn' }
        )
    })
  },
  solutions: {
    add: () => ({
      name: 'StoriesListingPage'
    }),
    delete: () => ({
      name: 'StoriesListingPage'
    })
  },
  sectors: {
    add: () => ({
      name: 'StoriesListingPage'
    }),
    delete: () => ({
      name: 'StoriesListingPage'
    })
  },
  subSectors: {
    add: () => ({
      name: 'StoriesListingPage'
    }),
    delete: () => ({
      name: 'StoriesListingPage'
    })
  },
  domains: {
    add: () => ({
      name: 'StoriesListingPage'
    }),
    delete: () => ({
      name: 'StoriesListingPage'
    })
  }
}
