import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import StoriesItem from '../components/stories/StoriesItem'
import SuccessStoriesModal from '../components/stories/SuccessStoriesModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('stories-item', StoriesItem)
    app.component('success-stories-modal', SuccessStoriesModal)
  })
}
