<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Custom;
use Inside\Host\Bridge\BridgeContent;

final class CreateCatalogsCustomPages extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();

        $custom = [
            'title' => 'Success stories',
            'introduction' => 'Retrouvez toutes les success stories SCC France !',
            'redirection_page' => 'StoriesListingPage',
            'custom_slug' => 'stories',
        ];

        $uuid = Custom::where('custom_slug', $custom['custom_slug'])->first()?->uuid;

        if ($uuid !== null) {
            $custom['uuid'] = $uuid;
        }

        $bridge->contentInsert('custom', $custom, $uuid === null);
    }
}
