<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class CreateWeightFieldForSpaces extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateOrUpdateField(
            'spaces',
            'weight',
            [
                'name' => 'weight',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'searchable_filter' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Poids',
                ],
                'description' => [
                    'fr' => 'Le chiffre le plus bas remonte en 1er',
                ],
                'widget' => [
                    'type' => BridgeContentType::NUMBER_WIDGET,
                    'settings' => [],
                    'weight' => 10,
                ],
                'type' => BridgeContentType::INTEGER_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
                'default' => 0,
            ],
            10
        );
    }
}
