<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class CreateCatalogsContentTypes extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->migrateContent('domains');
        $this->migrateContent('solutions');
        $this->migrateContent('sectors');
        $this->migrateContent('sub_sectors');
        $this->migrateContent('stories');
        $this->finishUp();
    }
}
